"Macro Data Sheet file v. 1"
gamesystem GURPS

title "GURPS Martial Arts (v. 3.0.0)"

version 253
level 3

copyright "Copyright  1996, 2001-2003 Steve Jackson Games Incorporated. All rights reserved. \
GURPS is a registered trademark of Steve Jackson Games Incorporated."

logo GURPS/MartialArts.lgo
help gurps.hlp

datafile GURPSCompendium.cds end

define
array maOptArr[1] 0
func getMAs(optName) "{\r\n\
local n;\r\n\
n = split(listOptions('optTextValue', optName, ','), ',', maOptArr);\r\n\
return n;\r\n\
}"

func minMACost(d) "optCount('Primary Skill') + optCount('Secondary Skill')/2"

func "ma1chk(level, cost)" "{\r\n\
local n, i, sec;\r\n\
if (noMACheck) return 1; endif\r\n\
n = getMAs('Primary Skill');\r\n\
if (cost < n + optCount('Secondary Skill')/2) return 0; endif\r\n\
if (n <= 0 or level<=15) return 1; endif\r\n\
i = 1;\r\n\
while (i <= sizeof(maOptArr))\r\n\
	if (countItems(format('Skills:@Secondary Skill=\"%s\"',maOptArr[i]),1,-1,'cost') = 0)\r\n\
	  return 1;\r\n\
	endif\r\n\
	i = i + 1;\r\n\
endwhile\r\n\
return 0;\r\n\
}"

func "ma2chk(level, levs, type, cost)" "{\r\n\
local minPrim, i, n;\r\n\
if (noMACheck) return 1; endif\r\n\
n = getMAs(type);\r\n\
if (type = 1 and cost < n/2 + optCount('Primary Skill')) return 0; endif\r\n\
if (n <= 0)\r\n\
  return 1;\r\n\
endif\r\n\
i = 1;\r\n\
while (i <= sizeof(maOptArr))\r\n\
	minPrim = findItemValue(format('Skills:@Primary Skill=\"%s\"',maOptArr[i]),'min','level');\r\n\
	if (minPrim>=15 or level<=minPrim-levs)\r\n\
		return 1;\r\n\
	endif\r\n\
	i = i + 1;\r\n\
endwhile\r\n\
return 0;\r\n\
}"

func "maCinChk(level)" "{\r\n\
local minPrim, i, n;\r\n\
if (noMACheck or level=0) return 1; endif\r\n\
n = getMAs('Cinematic Skill');\r\n\
if (n <= 0)\r\n\
  return 1;\r\n\
endif\r\n\
i = 1;\r\n\
while (i <= sizeof(maOptArr))\r\n\
	minPrim = findItemValue(format('Skills:@Primary Skill=\"%s\"',maOptArr[i]),'min','level');\r\n\
	if (minPrim>=16)\r\n\
		return 1;\r\n\
	endif\r\n\
	i = i + 1;\r\n\
endwhile\r\n\
return 0;\r\n\
}"

func "machk(level, cost)" "{\r\n\
local n, nok;\r\n\
if (optPresent('Primary Skill'))\r\n\
  n = n + 1; if (ma1chk(level, cost)) nok = nok + 1; endif;\r\n\
endif\r\n\
if (optPresent('Secondary Skill'))\r\n\
  n = n + 1; if (ma2chk(level, 1, 'Secondary Skill', cost)) nok = nok + 1; endif;\r\n\
endif\r\n\
if (optPresent('Optional Skill'))\r\n\
  n = n + 1; if (ma2chk(level, 2, 'Optional Skill', cost)) nok = nok + 1; endif;\r\n\
endif\r\n\
if (optPresent('Cinematic Skill'))\r\n\
  n = n + 1; if (maCinChk(level)) nok = nok + 1; endif;\r\n\
endif\r\n\
return n = 0 or nok > 0;\r\n\
}"

func "ma1msg(d, cost)" "{\r\n\
local minCost;\r\n\
minCost = minMACost(0);\r\n\
if (cost < minCost)\r\n\
  return minCost > 1 ? format('Skill occurs in multiple styles. Minimum cost: %d', minCost) : format('Minimum skill cost: %d', optValue('Minimum Cost'));\r\n\
endif\r\n\
return 'Primary skill cannot exceed 15 until 1 point spent in each secondary.';\r\n\
}"

func "ma2msg(d, cost)" "{\r\n\
local minCost;\r\n\
minCost = minMACost(0);\r\n\
if (cost > 0 and cost < minCost)\r\n\
  return format('Skill occurs in multiple styles. Minimum cost: %d', minCost);\r\n\
endif\r\n\
return 'Secondary skill must be less than minimum primary until all primaries are 15+.';\r\n\
}"

func maOptMsg(d) "'Optional skill must be 2 less than minimum primary until all primaries are 15+.'"
func maCinMsg(c) "'All primary skills must be at 16+ before cinematic skills can be learned.'"

func "mamsg(level, cost)" "{\r\n\
if (optPresent('Primary Skill') and !ma1chk(level, cost))\r\n\
  return ma1msg(level, cost);\r\n\
elseif (optPresent('Secondary Skill') and !ma2chk(level, 1, cost))\r\n\
  return ma2msg(level, cost);\r\n\
elseif (optPresent('Optional Skill') and !ma2chk(level, 2, cost))\r\n\
  return maOptMsg(level);\r\n\
elseif (optPresent('Cinematic Skill') and !maCinChk(level))\r\n\
  return maCinMsg(level);\r\n\
endif\r\n\
return 'Level not allowed for Martial Arts skill.';\r\n\
}"
func mavalue(opt,style,type) "findItemValue(format('Skills:@%s=\"%s\"',opt,style),type,'level')"
end

$$define PLUGIN MA

$$include gurps.inc
$$include GURPSMartialArts.inc


# Martial Arts skills

cat Skills
	sublist "Martial Arts" memlist
		sublist "Styles" memlist
			$$style(Aikido/Aiki-jutsu, 6/13,
				"Judo;Judo Art",
				"Katana Art;Shortsword Art",
				"Japanese,Staff,Theology[Theology (Shinto)]",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;Breakfall;Finger Lock;?allowdup;?itemref:Skill Reference=Judo;Ground Fighting",
				"Immovable Stance;Invisibility Art;Mental Strength;Pressure Points;Pressure Secrets;Push",
				"Roll with Blow")
			$$style(An Ch'i, 9/12, 
				"Fast-Draw[Fast-Draw (Shuriken)];Fast-Draw[Fast-Draw (Knife)];Holdout;Throwing;Traps",
				"Armoury;Blowpipe",
				"Karate,Judo,*Combat/Weapon",
				"?allowdup;?itemref:Skill Reference=Throwing;?opt:Minimum Cost=2;Hit Location;Feint",
				"Power Blow;Pressure Points;Throwing Art")
			$$style(Bando, 15/19,
				"Boxing;Judo;Karate;Philosophy[Philosophy (Buddhism)];Savoir-Faire (Dojo)",
				"Knife;Short Staff;Whip",
				"Body Language,Karate Sport,Malay,Tournament Law",
				"?itemref:Parry Reference=Karate;Aggressive Parry;?zref;?itemref:Skill Reference=Judo;Arm Lock;?zref;Elbow Strike;Head Butt;?zref;Head Lock;Jab;Knee Strike;?allowdup;?itemref:Skill Reference=Karate;Riposte;?zref;Shin Kick;Stamp Kick",
				"Breaking Blow;Mental Strength;Power Blow",
				"Roll with Blow")
			$$style(Capoeira, 8/12, 
				"Karate;Acrobatics;?zopt;Note[Note: If Acrobatics > Karate, you can substitute it for the Feint maneuver]",
				"Dancing[Dancing (Brazilian)];Judo;Jumping;Musical Instrument",
				"Knife,Portuguese,Shortsword,Staff",
				"Spin Kick;Sweeping Kick;?allowdup;?itemref:Skill Reference=Karate;?opt:Minimum Cost=2;Feint;Ground Fighting",
				"Power Blow",
				"Acrobatic Kick;Roll with Blow;Springing Attack")
			$$style(Chin Na, 11/16,
				"Judo;Karate",
				"Philosophy;Meditation",
				"Breath Control,Chinese (Mandarin),Chinese (Cantonese),Yin-Yang Healing",
				"Choke Hold;Finger Lock;Head Lock;Neck Snap;Spinning Punch;?opt:Minimum Cost=2;?allowdup;?itemref:Skill Reference=Judo;Arm Lock;?zref;?allowdup;?itemref:Skill Reference=Karate;Hit Location",
				"Breaking Blow;Hand of Death;Power Blow;Pressure Points;Pressure Secrets")
			$$style(Escrima, 13/17, 
				"Fast-Draw[Fast-Draw (Balisong)];Karate;Main-Gauche;Short Staff",
				"Judo",
				"Knife Throwing, Tagalog, Staff, Whip",
				"Elbow Strike;Knee Strike;?allowdup;?itemref:Skill Reference=ShortStaff;?opt:Minimum Cost=1;?itemref:Skill Reference=Judo;Arm Lock;?zref;?allowdup;?itemref:Skill Reference=Karate;?opt:Minimum Cost=2;Hit Location;?zref;?allowdup;?itemref:Skill Reference=MainGauche;Off-Hand Weapon Training;?zref;?allowdup;?itemref:Skill Reference=ShortStaff;Off-Hand Weapon Training",
				"Mental Strength;Power Blow;Pressure Points",
				"Roll with Blow")
			$$style(French Fencing, 10/17, 
				"Fencing[Fencing (Smallsword)];Fencing Art",
				"Acrobatics;Savoir-Faire (Dojo)[Savoir-Faire (Salle)];Tactics",
				"Black Powder Weapons, Body Language, Cloak, Main-Gauche, Riding (Horse), Wrestling",
				"?allowdup;?itemref:Skill Reference=Fencing;Close Combat (Long Weapon);?zref;Corps--Corps;?allowdup;?itemref:Skill Reference=Fencing;Feint;?zref;Flche;Lunge;?allowdup;?itemref:Skill Reference=Fencing;Off-Hand Weapon Training;Riposte;?zref;Stop Hit",
				,
				"Initial Carving;?opt:Skill='Fencing';Advantages:Enhanced Parry")
			$$style(Generic Martial Arts Style, 0)
			$$style(Goju Ryu, 10/17,
				"Breath Control;Karate;Karate Art;Meditation;Savoir-Faire (Dojo)",
				"Flail;Jitte/Sai;Staff;Tournament Law",
				"Katana,Theology[Theology (Taoism)],Tonfa,Yin-Yang Healing",
				"?itemref:Parry Reference=Karate;Aggressive Parry;?zref;Back Kick;Cat Stance;Elbow Strike;Knee Strike",
				"Breaking Blow;Immovable Stance;Kiai;Power Blow;Pressure Points;Pressure Secrets",
				"Roll with Blow")
			$$style(Hapkido, 11/14,
				"Karate;Judo",
				"Acrobatics;Jumping",
				"Korean",
				"Back Kick;Hook Kick;Jump Kick;?allowdup;?itemref:Skill Reference=Karate;Riposte;?zref;Shuto;Spin Kick;Sweeping Kick;?opt:Minimum Cost=2;Kicking",
				"Flying Leap;Power Blow;Pressure Points")
			$$style(Hashishin Style, 7,
				"Holdout;Knife;Shadowing;Stealth;Wrestling",
				"Broadsword;Brawling;Disguise;Knife Throwing;Poisons;Theology[Theology (Islamic)]",
				"Riding (Horse),Shield,Spear",
				"?allowdup;?itemref:Skill Reference=Knife;?opt:Minimum Cost=2;Feint")
			$$style(Hsing-Yi Chuan, 12/26,
				"Karate;Judo;Jumping",
				"Acrobatics;Breath Control;Meditation;Savoir-Faire (Dojo);?choose:Secondary Skills,1,Broadsword,Flail,Shortsword,Spear,Staff",
				"*Combat/Weapon,Philosophy[Philosophy (Taoist)]",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;Axe Kick;Back Kick;Cat Stance;Jump Kick;Hook Kick;Kicking;Spin Kick;Spinning Punch",
				"Breaking Blow;Flying Leap;Immovable Stance;Power Blow;Pressure Points;Pressure Secrets;Push",
				"Springing Attack;Advantages:Enhanced Parry (Bare Hands)")
			$$style(Isshinryu, 14/21,
				"Boxing;Karate;Karate Art;Savoir-Faire (Dojo)",
				"Jitte/Sai;Flail;Staff;Tonfa;Tournament Law",
				"Body Language,Breath Control,Katana,Philosophy[Philosophy (Taoism)],Yin-Yang Healing",
				"Back Kick;Cat Stance;Elbow Strike;Hook Kick;Jab;Jump Kick;Knee Strike;Shuto;Spin Kick;Stamp Kick",
				"Blind Fighting;Immovable Stance;Kiai;Power Blow;Pressure Points",
				"Flying Jump Kick;Roll with Blow")
			$$style(Italian Rapier Fencing, 9/24,
				"Cloak;Fencing[Fencing (Rapier)];Main-Gauche",
				"Acrobatics;Wrestling",
				"Black Powder Weapons,Broadsword,Riding (Horse),Savoir-Faire[Savoir-Faire (16th-century Italian)],Two-Handed Sword",
				"?allowdup;?itemref:Skill Reference=Fencing;Feint;?zref;?allowdup;?itemref:Skill Reference=MainGauche;Feint;?zref;Flche;?allowdup;?itemref:Skill Reference=Fencing;Hit Location;?zref;Lunge;?allowdup;?itemref:Skill Reference=MainGauche;Off-Hand Weapon Training",
				,
				"Advantages:Enhanced Dodge")
			$$style(Jeet Kune Do, 20/27,
				"Boxing;Judo;Karate",
				"Body Language",
				"Flail,Short Staff,Staff,*Melee",
				"Back Kick;Ear Clap;Elbow Strike;Hook Kick;Jab;Jump Kick;Knee Strike;Spinning Punch;Stamp Kick;Slip;?allowdup;?itemref:Skill Reference=Karate;Riposte;?opt:Minimum Cost=2;Feint;Hit Location;?zref;Spin Kick",
				"Breaking Blow;Immovable Stance;Mental Strength;Power Blow;Pressure Points;Pressure Secrets",
				"?allowdup;?itemref:Skill Reference=Judo;Sticking")
			$$style(Judo Style, 7,
				"Judo Art;Judo;Savoir-Faire (Dojo)",
				"Tournament Law[Tournament Law (Judo)]",
				"Meditation",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;Breakfall;?allowdup;?itemref:Skill Reference=Judo;?opt:Minimum Cost=2;Ground Fighting")
			$$style(Jujutsu, 7/12,
				"Judo;Karate",
				"Savoir-Faire (Dojo);?choose:Secondary Skills,1,Judo Art,Karate Art",
				"Kobujutsu,Katana,Boxing",
				"Back Kick;Spin Kick;?opt:Minimum Cost=1;?itemref:Skill Reference=Judo;?allowdup;Arm Lock;?zref;?opt:Minimum Cost=2;\
					?allowdup;?itemref:Skill Reference=*Melee,Disarming;Disarming",
				"Power Blow;Pressure Points;Pressure Secrets",
				"Binding;Roll with Blow")
			$$style(Kalaripayit, 7/14,
				"Judo;Karate;Theology[Theology (Hinduism)]",
				"Breath Control;Meditation;?choose:Secondary Skills,3,Broadsword,Knife,Shield,Shortsword,Spear,Staff,Two-Handed Axe/Mace",
				"Acrobatics,Jumping,Broadsword,Knife,Shield,Shortsword,Spear,Staff,Two-Handed Axe/Mace,Hindi",
				"Elbow Strike;Knee Strike;Spin Kick;?opt:Minimum Cost=1;?itemref:Skill Reference=Judo;Arm Lock;?zref",
				"Blind Fighting;Body Control;Mental Strength;Power Blow;Pressure Points;Pressure Secrets",
				"Roll with Blow")
			$$style(Karate Style, 11/16,
				"Karate;Karate Art;Savoir-Faire (Dojo)",
				"Judo;Tournament Law[Tournament Law (Karate)]",
				"Theology[Theology (Shinto)];?choose:Optional Skills,Axe/Mace,Flail,Jitte/Sai,Shield,Spear,Tonfa",
				"Back Kick;Elbow Strike;Hook Kick;Jump Kick;Kicking;Knee Strike;Spin Kick;Stamp Kick",
				"Breaking Blow;Kiai;Mental Strength;Power Blow;Pressure Points")
			$$style(Kempo, 6/26,
				"Judo;Karate;Philosophy[Philsophy (Zen Buddhism)]",
				"Meditation;Staff",
				"Breath Control,Yin/Yang Healing",
				"Kicking;Spin Kick;?opt:Minimum Cost=1;?itemref:Skill Reference=Judo;Arm Lock;?zref",
				"Body Control;Breaking Blow;Mental Strength;Power Blow;Pressure Points",
				"Advantages:Enhanced Dodge")
			$$style(Kendo, 7/15,
				"Katana Art",
				"Body Language;Meditation;?choose:Choose Philosophy,1,Philosophy[Philosophy (Shinto)],Philosophy[Philosophy (Zen Buddhism)],Philosophy[Philosophy (Confucianism)]",
				"Breath Control,Parry Missile Weapons",
				"Lunge;?allowdup;?itemref:Skill Reference=KatanaArt;Hit Location;Feint;Riposte",
				"Mental Strength;Power Blow[Power Blow (Katana)]",
				"?opt:Skill='Katana Art';Advantages:Enhanced Parry")
			$$style(Kenjutsu, 9/18,
				"Katana Art;Katana;Fast-Draw[Fast-Draw Katana]",
				"Body Language;Meditation;Philosophy",
				"Breath Control, Parry Missile Weapons",
				"Lunge;?allowdup;?itemref:Skill Reference=Katana;Hit Location;Feint;Riposte",
				"Mental Strength;Power Blow[Power Blow (Katana)]", 
				"Whirlwind Attack;?opt:Skill='Katana';Advantages:Enhanced Parry")
			$$style(Kobujutsu, 5/13,
				"Staff;?choose:Primary Weapon Skills,2,Axe/Mace,Flail,Jitte/Sai,Shield,Spear,Tonfa",
				"?uchoose:Secondary Weapon Skills,3,Axe/Mace,Flail,Jitte/Sai,Shield,Spear,Tonfa;Brawling",
				"Karate,Judo,*Melee",
				"?allowdup;?itemref:Skill Reference=*One-Handed,Off-Hand Weapon Training;Off-Hand Weapon Training",
				"Power Blow",
				"?opt:Minimum Cost=2;?allowdup;?itemref:Skill Reference=*One-Handed,Dual-Weapon Attack;Dual-Weapon Attack;Advantages:Enhanced Parry")
			$$style(Kuk Sool Won, 12/19,
				"Judo;Karate;Katana;Staff",
				"?uchoose:Secondary Weapon Skills,3,Main-Gauche,Short Staff,Shortsword,Throwing",
				"*Combat/Weapon,Philosophy[Philosophy (Buddhism)],Yin/Yang Healing",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;Back Kick;Jump Kick;Kicking;Spin Kick;?allowdup;?itemref:Skill Reference=Katana;Off-Hand Weapon Training;?allowdup;?itemref:Skill Reference=*Melee,Hit Location;Hit Location",
				"Mental Strength;Power Blow;Pressure Points;Pressure Secrets;Throwing Art",
				"Binding;Roll with Blow")
			$$style(Kuntao, 13/22, 
				"Judo;Karate;?choose:Primary Skills,3,Broadsword,Fencing,Flail,Knife,Staff,Throwing,Two-Handed Sword,Whip",
				"?uchoose:Secondary Skill,1,Chinese (Mandarin),Chinese (Cantonese);?uchoose:Secondary Skills,2,Broadsword,Fencing,Flail,Knife,Staff,Throwing,Two-Handed Sword,Whip",
				"Breath Control,Malaysian,Indonesian,Philosophy[Philosophy (Buddhism)],Philosophy[Philosophy (Taoism)]",
				"Back Kick;Finger Lock;Head Lock;Jump Kick;Kicking;?allowdup;?itemref:Skill Reference=Karate;Riposte;?zref;Spin Kick;?opt:Minimum Cost=1;?itemref:Skill Reference=Judo;Arm Lock;?zref",
				"Blinding Touch;Body Control;Breaking Blow;Hand of Death;Power Blow;Pressure Points;Pressure Secrets",
				"Flying Jump Kick;Roll with Blow")
			$$style(Kyudo, 5/10, 
				"Fast-Draw[Fast-Draw (Arrow)];Meditation;Philosophy[Philosophy (Zen Buddhism)];?opt:Minimum Cost=2;Bow",
				"Breath Control",
				"Calligraphy[Calligraphy (Japanese)]",
				,
				"Body Control;Mental Strength;Power Blow[Power Blow (Bow)];Pressure Points[Pressure Points (Bow)];Zen Archery")
			$$style(Military Hand-to-Hand, 7,
				"Brawling;Judo;Knife",
				"Climbing;Shortsword;Spear;Stealth",
				"Garrote,Jumping,Karate,Staff,Tonfa",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;?allowdup;?itemref:Skill Reference=GunsRfl;Retain Weapon;?zref;?opt:Minimum Cost=2;?allowdup;?itemref:Skill Reference=Judo;Disarming")
			$$style(Muay Thai, 18/20,
				"Boxing;Karate",
				"Judo",
				,
				"Axe Kick;Back Kick;Elbow Strike;Hook Kick;Jab;Jump Kick;?allowdup;?itemref:Skill Reference=Karate;Riposte;?zref;Roundhouse Punch;Shin Kick;Spin Kick;Spinning Punch;?opt:Minimum Cost=2;Kicking;?allowdup;?itemref:Skill Reference=Karate;Hit Location;?opt:Minimum Cost=1;Knee Strike",
				,
				"Flying Jump Kick;Roll with Blow")
			$$style(Ninjutsu, 23/39,
				"Karate;Judo;Stealth;?uchoose:Primary Weapon Skills,2,Axe/Mace,*Black Powder Weapons,Blowpipe,Bow,Garrote,Katana,Knife,Kusari,Lasso,Shortsword,Shuriken,Staff,Throwing,Flail,Jitte/Sai,Shield,Spear,Tonfa;?uchoose:Primary Athletic Skills,2,Acrobatics,Climbing,Jumping,Swimming",
				"?uchoose:Secondary Weapon Skills,2,Axe/Mace,*Black Powder Weapons,Blowpipe,Bow,Garrote,Katana,Knife,Kusari,Lasso,Shortsword,Shuriken,Staff,Throwing,Flail,Jitte/Sai,Shield,Spear,Tonfa;?uchoose:Primary Athletic Skills,2,Acrobatics,Climbing,Jumping,Swimming;?uchoose:Secondary Ninja Skills,3,Acting,Breath Control,Disguise,Escape,Fast-Talk,Forgery,Meditation,Tactics,Yin/Yang Healing",
				"*Combat/Weapon,Bard, Hypnotism,Sex Appeal,Acting,Breath Control,Disguise,Escape,Fast-Talk,Forgery,Meditation,Tactics,Yin-Yang Healing",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;Back Kick;Ear Clap;Elbow Strike;?allowdup;?itemref:Skill Reference=*Melee,Feint;Feint;?zref;?allowdup;?itemref:Skill Reference=*Hand-to-Hand,Ground Fighting;Ground Fighting;Head Butt;?zref;?allowdup;?itemref:Skill Reference=*Melee,Hit Location;Hit Location;?zref;Jump Kick;Knee Strike;?allowdup;?itemref:Skill Reference=*Melee,Riposte;Riposte;?zref;Spin Kick;Stamp Kick;?opt:Minimum Cost=2;?itemref:Parry Reference=Karate;Aggressive Parry",
				"Blind Fighting;Blinding Touch;Breaking Blow;Dislocating;Hand of Death;Hypnotic Hands;Invisibility Art;Light Walk;Mental Strength;Power Blow;Pressure Points;Pressure Secrets;Throwing Art",
				"Roll with Blow;?opt:Minimum Cost=2;Binding")
			$$style(Pakua, 5/30,
				"Judo;Meditation;Philosophy[Philosophy (Taoism)]",
				"Brawling",
				"Karate, Broadsword",
				"?opt:Minimum Cost=2;?itemref:Skill Reference=Judo;Arm Lock;?zref",
				"Immovable Stance;Mental Strength;Power Blow;Push",
				"Advantages:Enhanced Dodge;Advantages:Enhanced Parry (Bare Hands)")
			$$style(Pancratium/Mu Tau, 13/17,
				"Boxing;Karate;Wrestling",
				,
				"Greek,Latin,Philosophy",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;Jab;?allowdup;?itemref:Skill Reference=Karate;Riposte;?zref;Roundhouse Punch;Spinning Punch;Stamp Kick;?opt:Minimum Cost=2;?allowdup;?itemref:Skill Reference=*Hand-to-Hand,Hit Location;Hit Location;?zref;?allowdup;?itemref:Skill Reference=*Hand-to-Hand,Feint;Feint",
				"Breaking Blow;Power Blow;Immovable Stance",
				"Roll with Blow")
			$$style(Pao Chuan, 15/33,
				"Boxing;Karate;Karate Art;Meditation",
				"Judo;Body Language;Jumping;?choose:Language,1,Chinese (Mandarin),Chinese (Cantonese);Philosophy[Philosophy (Taoism)];?uchoose:Secondary Weapon Skill,2,Broadsword,Shortsword,Spear,Staff",
				"Broadsword,Shortsword,Spear,Staff,Acrobatics,Climbing",
				"Cat Stance;Jab;Jump Kick;Kicking;Spin Kick;Sweeping Kick;?allowdup;?itemref:Skill Reference=Karate;Feint;Hit Location;Riposte;?opt:Minimum Cost=2;Ground Fighting",
				"Blind Fighting;Light Walk",
				"Roll with Blow;Advantages:Enhanced Dodge")
			$$style(Pentjak Silat, 24/33,
				"Body Language;Judo;Karate;Main-Gauche;?uchoose:Primary Weapon Skill,1,Jitte/Sai,Kusari,Shortsword,Short Staff,Staff,Whip",
				"Acrobatics;Hypnotism;Jumping;?uchoose:Secondary Weapon Skill,1,Jitte/Sai,Kusari,Shortsword,Short Staff,Staff,Whip",
				"Jitte/Sai,Kusari,Shortsword,Short Staff,Staff,Whip",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;Back Kick;?allowdup;?itemref:Skill Reference=MainGauche;Close Combat;?zref;Elbow Strike;Finger Lock;\
					Head Lock;Jump Kick;Neck Snap;\
					?allowdup;?itemref:Skill Reference=*Melee,Riposte: Karate or Main-Gauche;Riposte;?zref;Spin Kick;\
					Sweeping Kick;?opt:Minimum Cost=2;\
					?allowdup;?itemref:Skill Reference=*Melee,Feint: Karate or Main-Gauche;\
					Feint;?allowdup;?itemref:Skill Reference=*Melee,Ground Fighting;Ground Fighting;?clear;\
					?list:Advantages;Advantages:Penalty Reduction[Penalty Reduction (Terrain Modifiers -2)]=4",
				"Breaking Blow;Hypnotic Hands;Mental Strength;Power Blow;Pressure Points;Pressure Secrets",
				"Acrobatic Kick;Roll with Blow;Springing Attack")
			$$style(Police Hand-to-Hand, 5,
				"Judo;Shortsword;?uchoose:Primary Skill,0-1,Tonfa",
				"Brawling;Wrestling",
				"Karate,Shield[Shield (Riot Shield)]",
				"Choke Hold;Retain Weapon;?opt:Minimum Cost=1;?itemref:Skill Reference=Judo;Arm Lock;?zref")
			$$style(Praying Mantis Kung Fu, 10/23,
				"Judo;Karate;Savoir-Faire (Dojo)",
				"Acrobatics;Jumping;Philosophy[Philosophy (Taoism)];Stealth",
				"Bow,Broadsword,Hypnotism,Two-Handed Sword,Hypnotism",
				"Elbow Strike;?allowdup;?itemref:Skill Reference=Karate;Hit Location;Riposte;?zref;Jump Kick;Kicking;Knee Strike;Spin Kick",
				"Hypnotic Hands;Light Walk;Power Blow;Pressure Points;Pressure Secrets;Push",
				"?allowdup;?itemref:Skill Reference=Judo;Sticking;Advantages:Enhanced Parry (Bare Hands)")
			$$style(Professional Boxing, 8/14,
				"Boxing;Tournament Law[Tournament Law (Boxing)]",
				"Body Language",
				"Running, Swimming",
				"Jab;Roundhouse Punch;Slip;?allowdup;?itemref:Skill Reference=Boxing;Riposte;?opt:Minimum Cost=2;Feint",
				,
				"Advantages:Enhanced Parry (Bare Hands)")
			$$style(Professional Kickboxing, 8,
				"Boxing;Karate",
				"Tournament Law[Tournament Law (Kickboxing)]",
				,
				"Jab;Jump Kick;?opt:Minimum Cost=2;Back Kick;Spin Kick")
			$$style(Professional Wrestling, 12,
				"Brawling;Wrestling;Wrestling Sport",
				"Acting;Performance;Tournament Law[Tournament Law (Pro Wrestling)]",
				"Acrobatics",
				"?itemref:Skill Reference=Wrestling;Arm Lock;?zref;Choke Hold;Ear Clap;Head Butt;Neck Snap;Piledriver;Stamp Kick;?opt:Minimum Cost=2;Drop Kick")
			$$style(Savate, 10/13,
				"Karate;Boxing",
				"Broadsword",
				"Fencing,French",
				"Back Kick;Drop Kick;Jump Kick;Spin Kick;?opt:Minimum Cost=2;Kicking;?allowdup;?itemref:Skill Reference=Karate;Hit Location",
				"Acrobatics",
				"Acrobatic Kick;Flying Jump Kick")
			$$style(Self-Defense Hand-to-Hand, 1,
				"Judo;Karate",
				,
				,
				"Hand Parry;Hand Strike;Judo Throw;Judo Parry")
			$$style(Shaolin Kung Fu, 16/32,
				"Judo;Karate;Meditation;Philosophy[Philosophy (Buddhism)]",
				"Acrobatics;Breath Control;Calligraphy;History[History (Chinese)];Literature[Literature (Chinese)];Jumping;Spear;Staff;Stealth;Theology[Theology (Buddhism)];Throwing",
				"Bow,Broadsword,Hypnotism,Two-Handed Sword,Yin/Yang Healing",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;Axe Kick;Back Kick;Hook Kick;Kicking;Spinning Punch;?opt:Minimum Cost=2;?allowdup;?itemref:Skill Reference=Karate;Feint;?zref;Jump Kick;Spin Kick",
				"Blind Fighting;Blinding Touch;Breaking Blow;Drunken Fighting;Hand of Death;Invisibility Art;Light Walk;Power Blow;Pressure Points;Pressure Secrets;Throwing Art;Zen Archery",
				"Flying Jump Kick;Hand-Clap Parry;Roll with Blow;Springing Attack")
			$$style(Streetfighting, 16,
				"Brawling;Running;Stealth;Streetwise;?uchoose:Primary Weapon Skill,1,Broadsword,Knife,Shortsword",
				"Climbing;Holdout;Jumping;Karate;Survival[Survival (Urban)];?uchoose:Secondary Weapon Skill,1,Broadsword,Knife,Shortsword",
				"Fast-Talk,Intimidation,*Guns,Scrounging",
				"Eye-Gouging;Face Attacks;?allowdup;?itemref:Skill Reference=Brawling;Feint;Hit Location;?zref;Head Butt;Kicking;Knee Strike;Neck Snap;Rabbit Punch;Roundhouse Punch;Stamp Kick")
			$$style(Sumo, 5/5,
				"Sumo Wrestling;Tournament Law[Tournament Law (Sumo)]",
				"Theology[Theology (Shinto)]",
				"Brawling, Karate, Meditation, Wrestling",
				,
				"Immovable Stance;Mental Strength;Power Blow")
			$$style(Tae Kwon Do, 14/21,
				"Jumping;Karate;Karate Sport;Savoir-Faire (Dojo)",
				"Acrobatics;Tournament Law[Tournament Law (Tae Kwon Do)]",
				"Judo,*Combat/Weapon",
				"Axe Kick;Back Kick;Elbow Strike;Hook Kick;Spin Kick;Sweeping Kick;?opt:Minimum Cost=2;Jump Kick;Kicking",
				"Breaking Blow;Flying Leap;Power Blow",
				"Acrobatic Kick;Roll With Blow;?opt:Minimum Cost=2;Flying Jump Kick")
			$$style(T'ai Chi Chuan, 5/28,
				"Judo;Judo Art;Meditation;Philosophy;?choose:If Allowed in Realistic Campaign,0-1,Push",
				"Broadsword Art;Karate",
				"Breath Control,Shortsword Art,Generic PA Combat/Weapon Sport[Spear Art],Generic PA Combat/Weapon Sport[Staff Art],Yin/Yang Healing",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;?opt:Minimum Cost=2;?choose:If Allowed in Realistic Campaign,0-1,Sticking",
				"Body Control;Immovable Stance;Mental Strength;Pressure Points;Pressure Secrets;Push",
				"?opt:Minimum Cost=2;?uchoose:Cinematic Maneuver,1,Sticking;Advantages:Enhanced Dodge")
			$$style(Uechi Ryu, 11/21,
				"Breath Control;Karate;Karate Art;Meditation;Savoir-Faire (Dojo)",
				"Jitte/Sai;Staff;Tonfa",
				"Karate Sport,Philosophy[Philosophy (Buddhism)],Tournament Law,Axe/Mace,Flail,Jitte/Sai,Shield,Spear,Tonfa",
				"?itemref:Parry Reference=Karate;Aggressive Parry;?zref;Back Kick;Elbow Strike;Hook Kick;Knee Strike;Shin Kick",
				"Breaking Blow;Immovable Stance;Kiai;Power Blow",
				"?opt:Skill='Karate';Advantages:Enhanced Parry")
			$$style(White Crane Kung Fu, 7/13,
				"Karate;Philosophy[Philosophy (Taoism)]",
				"Judo;Jumping;?uchoose:Language,1,Chinese (Mandarin),Chinese (Cantonese);Meditation;?uchoose:Secondary Weapon Skills,2,Broadsword,Knife,Shortsword,Spear,Staff,Whip",
				"Broadsword,Knife,Shortsword,Spear,Staff,Whip",
				"Back Kick;Jump Kick;?allowdup;?itemref:Skill Reference=Karate;Riposte;?zref;?opt:Minimum Cost=2;Spin Kick",
				,
				"?cat:Advantages;?choose:Cinematic Maneuver,1,Enhanced Parry,Enhanced Parry (Bare Hands)")
			$$style(Wing Chun Kung Fu, 14/32,
				"Judo;Karate;Shortsword",
				"Knife;Philosophy[Philosophy (Zen Buddhism)];Two-Handed Sword",
				"Meditation,Staff",
				"?itemRef:Skill Reference=Judo;Arm Lock;?zref;Back Kick;\
					?setval:Choose close combat weapon.,_ccweap,Knife,Shortsword;?allowdup;\
					?if:_ccweap='Knife';?itemref:Skill Reference=Knife;Close Combat;?else;?itemref:Skill Reference=Shortsword;Close Combat (Long Weapon);?endif;\
					Elbow Strike;Knee Strike;\
					?allowdup;?itemref:Skill Reference=Shortsword;Off-Hand Weapon Training;?zref;\
					?allowdup;?itemref:Skill Reference=Karate;Riposte;?zref;Spin Kick;Stamp Kick;\
					?opt:Minimum Cost=2;?allowdup;?itemref:Skill Reference=Karate;Feint",
				"Immovable Stance;Mental Strength;Power Blow;Pressure Points;Pressure Secrets",
				"Sticking;?opt:Minimum Cost=2;?allowdup;?itemref:Skill Reference=Shortsword;Dual-Weapon Attack;\
					Advantages:Enhanced Parry (All Weapons)")
			$$style(Wudong, 13/30,
				"Acrobatics;Breath Control;Judo;Karate;Karate Art",
				"Jumping;Philosophy[Philosophy (Taoism)]",
				"Meditation,Yin/Yang Healing",
				"?itemref:Skill Reference=Judo;Arm Lock;?zref;Back Kick;Elbow Strike;Hook Kick;Jump Kick;Kicking;Knee Strike;Spin Kick",
				"Body Control;Breaking Blow;Drunken Fighting;Hand of Death;Immovable Stance;Mental Strength;Power Blow;Pressure Points;Pressure Secrets",
				"Springing Attack;Acrobatic Kick;Advantages:Enhanced Parry (Bare Hands)")
			$$style(Wushu Kung Fu, 10/20,
				"Acrobatics;Jumping;Karate;Karate Art",
				"Judo Art;?choose:Choose if Allowed in School,0-1,Judo;Philosophy[Philosophy (Communist Doctrine)];?choose:Secondary Weapon Skills,2,Axe/Mace,Broadsword,Flail,Knife,Shortsword,Spear,Staff,Whip",
				"Breath Control,Meditation,Yin/Yang Healing,*Melee",
				"Back Kick;Hook Kick;?allowdup;?itemref:Skill Reference=*One-Handed,Off-Hand Weapon Training;Off-Hand Weapon Training;?zref;Spin Kick;?opt:Minimum Cost=2;Jump Kick",
				"Breaking Blow;Flying Leap;Hand of Death;Mental Strength;Power Blow;Pressure Points;Pressure Secrets",
				"?allowdup;?itemref:Skill Reference=*One-Handed,Dual-Weapon Attack;Dual-Weapon Attack;Flying Jump Kick")
			sublist "Fictional Styles" memlist
				sublist "Alien Styles" memlist
					$$style(Engaijutsu, 15/30, 
						"Breath Control;Judo;Karate;Meditation",
						"Acrobatics;Carousing;Hypnotism;Jumping;Yin/Yang Healing",
						"*Athletic,Philosophy[Philosophy (Engai)],Staff,Stealth",
						"?itemref:Skill Reference=Judo;Arm Lock;?zref;Back Kick;Choke Hold;Elbow Strike;?allowdup;?itemref:Skill Reference=Karate;Feint;?zref;\
							Finger Lock;Head Lock;Jump Kick;Kicking;Knee Strike;Spin Kick",
						"Blinding Touch;Body Control;Breaking Blow;Flying Leap;Hypnotic Hands;Immovable Stance;\
							Light Walk;Mental Strength;Power Blow;Pressure Points;Pressure Secrets;Push",
						"Acrobatic Kick;Flying Jump Kick;Roll with Blow")
					$$style(Kronin Karate, 14/17,
						"?datasheet:GURPSPsionics.cds;Broadsword;Force Shield;Judo;Karate;Mental Blow;Mind Shield;Telereceive;Telesend",
						"Free Fall;Stealth;Throwing",
						"*Psionic,Acrobatics,Jumping,Knife,Staff",
						"?itemref:Skill Reference=Judo;Arm Lock;?zref;Back Kick;Hook Kick;Spin Kick;?opt:Minimum Cost=2;\
							?allowdup;?setval:Choose Karate or Broadsword for Feint,_temp,Karate,Broadsword;?if:_temp='Karate';?itemref:Skill Reference=Karate;?else;?itemref:Skill Reference=Broadsword;?endif;Feint",
						"Breaking Blow;Power Blow;Pressure Points")
					$$style(Reticulate Style, 17/25,
						"Hypnotism;Judo;Karate;Wrestling",
						"Physiology[Physiology (Human)];Physiology[Physiology (Kaa)]",
						"Anthropology,Interrogation,Psychology,Xenobiology[Xenobiology (Human)]",
						"Aggressive Tail Parry;Breakfall;?allowdup;?itemref:Skill Reference=Judo;Feint;\
							Ground Fighting;?zref;?allowdup;?itemref:Skill Reference=Karate;Hit Location;?zref;\
							Hook Kick[Hook Kick (Tail)];Kicking[Kicking (Tail)];Neck Snare;Spin Kick[Spin Kick (Tail)];\
							Sweeping Kick[Sweeping Kick (Tail)];?opt:Minimum Cost=2;?itemref:Skill Reference=Judo;Arm Lock;?zref",
						"Breaking Blow;Immovable Stance;Invisibility Art;Power Blow;Pressure Points;Pressure Secrets",
						"Binding;?allowdup;?itemref:Skill Reference=Judo;Sticking")
					end
				sublist "Fantasy Styles" memlist
					$$style(Aerie Fighting, 10/25,
						"Bolas;Bow;Karate;Throwing;?opt:Minimum Cost=2;Flight",
						"Acrobatics;Fast-Draw[Fast-Draw (Arrow)];Fast-Draw[Fast-Draw (Knife)]",
						"Net,Spear,Theology[Theology (Winged Folk)]",
						"Jump Kick;Kicking;Knee Strike;Swooping Kick",
						"Power Blow;Throwing Art;Zen Archery",
						"?opt:Only When Flying;Advantages:Enhanced Dodge")
					$$style(Dragon-Man Kung Fu, 11/20,
						"?datasheet:GURPSMagic.cds;Judo;Karate;Magic Breath;Philosophy[Philosophy (Dragon Temple)];\
							?uchoose:Primary Weapon Skill,1,Katana,Shortsword,Spear,Staff",
						"Acrobatics;Breath Control;Jumping;Meditation;Stealth;Yin/Yang Healing;?uchoose:Secondary Weapon Skill,1,Katana,Shortsword,Spear,Staff",
						"*Combat/Weapon",
						"?itemref:Skill Reference=Judo;Arm Lock;?zref;Axe Kick;Back Kick;Jump Kick;Spin Kick;Spinning Punch",
						"Blinding Touch;Breaking Blow;Flying Leap;Mental Strength;Power Blow;Pressure Points;Pressure Secrets",
						"Flying Jump Kick;Roll with Blow;?close;?clear;?list:Advantages;?cat:Advantages;?choose:Tattoo,1,*Dragon Temple Tattoo")
					$$style(Smasha, 13/18,
						"Boxing;Brawling;Wrestling",
						"Jumping;Knife;Stealth;?uchoose:Secondary Weapon Skill,1,*Combat/Weapon",
						"Acrobatics,Holdout",
						"?allowdup;?itemref:Parry Reference=Brawling;Aggressive Parry;?zref;?itemref:Skill Reference=Wrestling;Arm Lock;?zref;Eye-Gouging;Face Attacks;Head Butt;Jab;Kicking;Rabbit Punch;Roundhouse Punch;Stamp Kick",
						"Kiai;Power Blow;Pressure Points;Pressure Secrets",
						"Roll with Blow")
					$$style(Sylvan War Lore, 9/15,
						"Brawling;Staff;Stealth;Survival (Woodlands);Wrestling",
						"Acrobatics;Breath Control;Camouflage;Climbing;Jumping;Meditation;Tracking",
						"Bow,Hypnotism,First Aid,Knife,Knife Throwing",
						"?itemref:Skill Reference=Wrestling;Arm Lock;?zref;?allowdup;?itemref:Skill Reference=*Melee,Disarming;Disarming;Drop Kick;Staff Vault",
						"Blind Fighting;Body Control;Invisibility Art;Light Walk;Mental Strength",
						"Roll with Blow")
					end
				sublist "Futuristic Styles" memlist
					$$style(Cyberninjutsu, 15,
						"Acting;Holdout;Judo;Karate;Poisons;Stealth",
						"Climbing;Fast-Draw[Fast-Draw (Claws)];Fast-Talk;Jumping;Sex Appeal;Shadowing;?choose:Secondary Weapon Skills,2,*Combat/Weapon",
						"*Combat/Weapon,Armoury[Armoury (Cybernetic Weapons)],Demolitions",
						"?itemref:Parry Reference=Karate;Aggressive Parry;?zref;?itemref:Skill Reference=Judo;Arm Lock;?zref;Eye-Gouging;Elbow Strike;?allowdup;?itemref:Skill Reference=Karate;Feint;?zref;Head Butt;Finger Lock;Knee Strike;Neck Snap")
					$$style(Force-Swordsmanship, 7/21,
						"Acrobatics;Katana[Katana (Force Sword)];Katana Art[Katana Art (Force Sword)]",
						"Jumping;Savoir-Faire (Dojo);Wrestling",
						"Karate",
						"?allowdup;?itemref:Skill Reference=Katana;Hit Location;Off-Hand Weapon Training;?opt:Minimum Cost=2;Feint",
						"Blind Fighting;Flying Leap;Kiai;Mental Strength;Power Blow;Parry Missile Weapons;Precognitive Parry",
						"Whirlwind Attack;?opt:Skill='Katana (Force Sword)';Advantages:Enhanced Parry")
					$$style(Spacer Kung Fu, 15,
						"Free Fall;Judo;Jumping;Karate;Knife;Vacc Suit;?rmopt:Primary Skill;Advantages:Penalty Reduction[Penalty Reduction (Vacc Suit DX -1)]=4",
						"Acrobatics;Climbing",
						"Fast-Draw[Fast-Draw (Knife)],Fast-Draw[Fast-Draw (Power Holster)],Knife Throwing,Stealth",
						"?itemref:Skill Reference=Judo;Arm Lock;?zref;Jump Kick;?allowdup;?itemref:Skill Reference=Knife;Close Combat;?zref;?opt:Minimum Cost=2;?allowdup;?itemref:Skill Reference=*Melee,Hit Location: Karate or Knife;Hit Location")
					
					end
				end
			end

		$$macombo()

		sublist "Maneuvers" memlist
			$$martman	Aggressive Parry	Hard	iteminfo('`Parry Reference`')-4+0*combatreflexes*b_bhparry*zparry	Karate>=slc(12)|$itemInfo('`Skill Reference`')>=slc(12)::$format('Skill must %d or greater',slc(12))	iteminfo('`Parry Reference`')			x
				opt
					begin text "Parry Reference" "?!@Parry@" noprint itemrefcat "Melee" end
					end
			$$martman	Aggressive Weapon Parry	Hard	iteminfo('`Parry Reference`')-4+0*combatreflexes*wpbonus(0)*b_1wparry	Karate>=slc(12)|$itemInfo('`Skill Reference`')>=slc(12)::$format('Skill must %d or greater',slc(12))	iteminfo('`Parry Reference`')			x	^n (^x|optTextValue('Parry Reference')|)
				opt
					begin text "Parry Reference" "?!@Parry@" noprint itemrefcat "Melee" end
					end

			$$martman	Aggressive Parrying Kick	Hard	max(Karate/2,Brawling/2)+combatreflexes+b_bhparry-4	Karate>=slc(12)|Brawling>=slc(12)	integer(max(Karate,Brawling)/2)+combatreflexes+b_bhparry			x
			$$martman	Arm Lock	Avg	max(judo,wrestling,iteminfo('`Skill Reference`'))	Judo>=slc(12)|Wrestling>=slc(12)|$iteminfo('`Skill Reference`')>=slc(12)::$format('Skill must be %d or greater',slc(12))			Hand-to-Hand
			$$martman	Wrist Lock	Avg	max(judo,wrestling)	Judo>=slc(12)|Wrestling>=slc(12)
			$$martman	Axe Kick	Hard	max(Karate-4,Kicking-2)	Karate>=slc(12)|Kicking>=slc(12)	max(Karate,Kicking)	thr+KarateDmg(2)
			$$martman	Back Kick	Hard	max(karate-4,kicking-2)	Karate>=slc(12)	Karate	thr+KarateDmg(0)
			$$martman	Breakfall	Avg	max(Judo,Acrobatics)	Judo>=slc(12)
			$$martman	Cat Stance	Avg	Karate-3	Karate>=slc(12)	Karate+2
			$$martman	Choke Hold	Hard	max(Judo-2,Wrestling-3)	Judo>=slc(12)|Wrestling>=slc(12)	max(Judo,Wrestling)
			$$martman	Close Combat	Avg	iteminfo('`Skill Reference`')-2	#1,Skills:Close>=slc(12)	iteminfo('`Skill Reference`')		Close
			$$martman	Close Combat (Long Weapon)	Avg	iteminfo('`Skill Reference`')-6	#1,Skills:Long Weapon>=slc(12)	iteminfo('`Skill Reference`')-3		Long Weapon
			$$martman	Corps--Corps	Hard	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber,JitteSai)	#1,Skills:Fencing>=slc(12)|Jitte/Sai>=slc(12)	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber,JitteSai)+2
			$$martman	Disarming	Hard	max(dx,Judo,itemInfo('`Skill Reference`'))				Melee
			$$martman	Drop Kick	Hard	max(Karate-4,Wrestling-4)	Karate>=slc(12)|Wrestling>=slc(12)	max(Karate,Wrestling)	thr+KarateDmg(2)
			$$martman	Ear Clap	Avg	max(Karate-6,Brawling-6)	Karate>=slc(12)|Brawling>=slc(12)	max(Karate,Brawling)
			$$martman	Elbow Strike	Avg	karate-2	Karate>=slc(12)	Karate	thr+KarateDmg(-2)
			$$martman	Eye-Gouging	Hard	max(Brawling-9,Karate-9)	Brawling>=slc(12)|Karate>=slc(12)	max(Brawling,Karate)	thr+max(BrawlDmg(-4),KarateDmg(-4))
			$$martman	Face Attacks	Hard	brawling-5	Brawling>=slc(12)	Brawling	thr+brawlDmg(-3)
			$$martman	Feint	Hard	iteminfo('`Skill Reference`')		iteminfo('`Skill Reference`')+4		Melee
			$$martman	Finger Lock	Hard	ArmLock-3	Arm Lock>=slc(12)
			$$martman	Flche	Avg	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber)-3	#1,Skills:Fencing>=slc(12)	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber)
			$$martman	Floor Lunge	Hard	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber)-4	#1,Skills:Fencing>=slc(12)	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber)
			$$martman	Ground Fighting	Hard	iteminfo('`Skill Reference`')-4		iteminfo('`Skill Reference`')		Combat/Weapon
			$$martman	Hand Parry	Spec	integer(max(karate,Brawling,Boxing)*2/3)+b_bhparry+combatreflexes	Karate>=slc(12)|Brawling>=slc(12)|Boxing>=slc(12)	integer(max(Karate,Brawling,Boxing)*2/3)+b_bhparry+combatreflexes			x
			$$martman	Hand Strike	Spec	max(karate,Brawling,Boxing)	Karate>=slc(12)|Brawling>=slc(12)|Boxing>=slc(12)	max(Karate,Brawling,Boxing)	thr+max(KarateDmg(-2),BrawlDmg(-2),integer(Boxing/5)-2)
			$$martman	Head Butt	Avg	max(Brawling,Karate)-6	Brawling>=slc(12)|Karate>=slc(12)	max(Brawling,Karate)	thr-1
			$$martman	Head Lock	Hard	max(Judo,Wresting)-4	Judo>=slc(12)|Wrestling>=slc(12)	max(Judo,Wrestling)
			$$martman	Hit Location	Hard	iteminfo('`Skill Reference`')-3		iteminfo('`Skill Reference`')		Combat/Weapon
			$$martman	Hook Kick	Hard	max(Karate-3,Kicking-1)	Karate>=slc(12)	karate	thr+KarateDmg(1)
			$$martman	Horse Archery	Hard	Bow-4	Bow>=slc(12);#1,Skills:Riding>=slc(12)	Bow
			$$martman	Jab	Avg	max(Boxing-3,Karate-3)	Boxing>=slc(12)|Karate>=slc(12)	max(Boxing,Karate)	thr+integer(boxing/5)-3
			$$martman	Judo Parry	Spec	integer(Judo*2/3)+b_bhparry+combatreflexes	Judo>=slc(12)	integer(Judo*2/3)+b_bhparry+combatreflexes			x
			$$martman	Judo Throw	Spec	Judo	Judo>=slc(12)	Judo
			$$martman	Jump Kick	Hard	max(Karate-4,Kicking-2)	Karate>=slc(12)	Karate	thr+KarateDmg(2)
			$$martman	Kicking	Hard	max(Karate,Brawling)-2	Karate>=slc(12)|Brawling>=slc(12)	max(Karate,Brawling)	thr+max(BrawlDmg(0),KarateDmg(0))
			$$martman	Knee Strike	Avg	max(Karate,Brawling)-1	Karate>=slc(12)|Brawling>=slc(12)	max(Karate,Brawling)+2	thr+max(BrawlDmg(-1),KarateDmg(-1))
			$$martman	Leg Grapple	Spec	max(Brawling,Judo,Karate)	Brawling>=slc(12)|Judo>=slc(12)|Karate>=slc(12)	max(Brawling,Judo,Karate)
			$$martman	Lunge	Avg	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber,Katana,KatanaArt)-2	#1,Skills:Fencing>=slc(12)|Katana>=slc(12)|Katana Art>=slc(12)	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber,Katana,KatanaArt)
			$$martman	Neck Snap	Hard	ST-4		ST+3	sw
			$$martman	Off-Hand Weapon Training	Hard	iteminfo('`Skill Reference`')-4		iteminfo('`Skill Reference`')		One-Handed
			$$martman	Parrying Kick	Spec	integer(max(Karate,Brawling)/2)+b_bhparry+combatreflexes	Karate>=slc(12)|Brawling>=slc(12)	integer(max(Karate,Brawling)/2)+b_bhparry+combatreflexes			x
			$$martman	Rabbit Punch	Avg	Brawling-3	Brawling>=slc(12)	Brawling	sw+BrawlDmg(0)
			$$martman	Retain Weapon	Hard	max(dx,iteminfo('`Skill Reference`'))				Weapon
			$$martman	Retain Weapon (Ranged)	Hard	DX				Ranged
			$$martman	Riposte	Hard	iteminfo('`Skill Reference`')-4		iteminfo('`Skill Reference`')		Melee
			$$martman	Roundhouse Punch	Avg	max(Brawling-3,Boxing-3)	Brawling>=slc(12)|Boxing>=slc(12)	max(Brawling,Boxing)	sw+max(BrawlDmg(-1),integer(Boxing/5)-1)
			$$martman	Shin Kick	Hard	max(Karate-3,Kicking-1)	Karate>=slc(12)	Karate	thr+KarateDmg(2)
			$$martman	Shuto	Hard	Karate-3	Karate>=slc(12)	Karate	thr+KarateDmg(-2)
			$$martman	Slip	Hard	u_dodge-3	Boxing>=slc(12)	u_dodge
			$$martman	Spin Kick	Hard	max(Karate-3,Kicking-1)	Karate>=slc(12)	Karate	thr+KarateDmg(0)
			$$martman	Spinning Punch	Hard	Karate-2	Karate>=slc(12)	Karate	thr+KarateDmg(-2)
			$$martman	Stop Hit	Hard	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber)-4	#1,Skills:Fencing>=slc(12)	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber)
			$$martman	Stamp Kick	Avg	max(Brawling-3,Karate-3,Kicking-1)	Karate>=slc(12)|Brawling>=slc(12)	max(Brawling,Karate)	thr+Max(KarateDmg(1),BrawlDmg(1))
			$$martman	Sweeping Kick	Hard	max(Karate-3,Kicking-1)	Karate>=slc(12)	Karate
			$$martman	Trip	Spec	Judo	Judo>=slc(12)	Judo
			$$martman	Yawara	Avg	max(Karate-3,Brawling-5)	Karate>=slc(12)|Brawling>=slc(12)	max(Karate,Brawling)	thr+max(KarateDmg(3),BrawlDmg(3))
			end
		sublist "Cinematic Maneuvers" memlist
			$$martman	Acrobatic Kick	Hard	Acrobatics-4	Acrobatics>=slc(12);Kicking>=slc(12)		thr+KarateDmg(0)
			$$martman	Binding	Hard	Judo	Judo>=slc(12)
			$$martman	Dual-Weapon Attack	Hard	iteminfo('`Skill Reference`')-4	#1,Skills:One-Handed>=slc(12)	iteminfo('`Skill Reference`')		One-Handed
			$$martman	Fighting While Seated	Hard	iteminfo('`Skill Reference`')-2		iteminfo('`Skill Reference`')		Combat/Weapon
			$$martman	Flying Jump Kick	Hard	max(karate-6,Kicking-4)	Karate>=slc(12)|Kicking>=slc(12)	max(Karate,Kicking)	thr+KarateDmg(2)
			$$martman	Hand-Clap Parry	Hard	integer(2*max(Karate,Judo)/3)+combatreflexes+b_bhparry-5	Karate>=slc(12)|Judo>=slc(12)	integer(2*max(Karate,Judo)/3)+combatreflexes+b_bhparry			x
			$$martman	Initial Carving	Avg	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber)-4	#1,Skills:Fencing>=slc(12)	max(Fencing,FencingRapier,FencingSmallsword,FencingSaber)
			$$martman	Piledriver	Hard	Wrestling-4	Wrestling>=slc(12)		sw+integer(Wrestling/5)
			$$martman	Roll with Blow	Hard	max(Acrobatics-2,dx-6)	Acrobatics>=slc(12)|Judo>=slc(12)
			$$martman	Springing Attack	Avg	acrobatics-3	Acrobatics>=slc(12);Karate>=slc(12)
			$$martman	Sticking	Hard	max(Judo-4,iteminfo('`Skill Reference`')-2)	Skills:Judo>=14
			$$martman	Whirlwind Attack	Hard	max(Katana-5,Staff-5)	Katana>=slc(12)|Staff>=slc(12)	max(Katana,Staff)
			end
		sublist "Fictional Maneuvers" memlist
			$$martman	Swooping Kick	Hard	Kicking-4	Flight>=15		sw+KarateDmg(0)
			$$martman	Staff Vault	Hard	DropKick-4	Drop Kick>=slc(12);Staff>=slc(12)
			$$martman	Aggressive Tail Parry	Hard	integer(Karate/2)+b_bhparry+combatreflexes-4	Karate>=slc(12);Adv:Extra Flexibility	integer(Karate/2)+b_bhparry+combatreflexes			x
			$$martman	Neck Snare	Hard	Judo-4	Judo>=slc(12);Adv:Extra Flexibility
			end
		end
	sublist "Cinematic" memlist
		$$skill	Blind Fighting	MVH!	Cinematic		"Adv:Trained By A Master|Adv:Weapon Master"
		$$skill	Blinding Touch	MVH!	Cinematic		"Adv:Trained By A Master;Pressure Points>=15"
		$$skill	Body Control	MVH!	Cinematic		"Adv:Trained By A Master;Breath Control;Meditation"
		$$skill	Breaking Blow	MH!	Cinematic		"Adv:Trained By A Master"
		$$skill	Dislocating	PH	Cinematic		"Adv:Trained By A Master;Escape>=15"
		$$skill	Drunken Fighting	PH	Cinematic		"Adv:Trained By A Master~Karate>=max(DX+3,16)|Judo>=max(DX+3,16)"			skchk(x,c) and x<=max(Karate,Judo)
		$$skill	Flying Fists	MVH!	Cinematic		"Adv:Trained By A Master;Karate>=20;Power Blow>=16;Breaking Blow>=16;Mental Strength>=16;Meditation>=16"
		$$skill	Flying Leap	MH!	Cinematic		"Adv:Trained By A Master;Power Blow;Jumping|Adv:Weapon Master;Power Blow;Jumping"
		$$skill	Hand of Death	MVH!	Cinematic		"Adv:Trained By A Master;Breaking Blow>=20;Pressure Secrets>=20;Power Blow>=20"
		$$skill	Hypnotic Hands	MH!	Cinematic		"Adv:Trained By A Master;Hypnotism>=15"
		$$skill	Immovable Stance	PH	Cinematic		"Adv:Trained By A Master"
		$$skill	Invisibility Art	MVH!	Cinematic		"Adv:Trained By A Master;Hypnotism>=16;Stealth>=16"
		$$skill	Kiai	PH/HT	Cinematic		"Adv:Trained By A Master|Adv:Weapon Master"
		$$skill	Light Walk	MH!	Cinematic		"Adv:Trained By A Master;Acrobatics>=15;Stealth>=15"
		$$skill	Mental Strength	MH!	Cinematic		"Adv:Trained By A Master|Adv:Weapon Master"		"$(skfunc)(~x,iq+will)"
		$$skill("Mountain Heart", MVH!, "Cinematic", , "Adv:Trained By A Master;Sk:Body Control>=15")
		$$skill("Muscle Reading", MVH!, "Cinematic", , "Adv:Trained By A Master;Sk:Physiology>=12;Sk:Psychology>=12")
		$$skill	Power Blow	MH!	Cinematic		"Adv:Trained By A Master|Adv:Weapon Master"
		$$skill	Precognitive Parry	MH!	Cinematic		"Adv:Weapon Master|Adv:Trained By A Master~Powers:ESP>=3;Skills:Precognition>=15|Adv:Danger Sense~#1,Skills:Melee>=20"		mh(~x-wpbonus(optValue('Weapon Skill')),iq)+0*b_1wparry				^n (^o'Weapon Skill')
			opt begin text "Weapon Skill" "Choose" keepold noprint end
				end
		$$skill	Pressure Points	MH!	Cinematic	YinYangHealing-4	"Adv:Trained By A Master|Adv:Weapon Master"
		$$skill	Pressure Secrets	MVH!	Cinematic		"Adv:Trained By A Master;Pressure Points>=18"
		$$skill	Push	PH	Cinematic		"Adv:Trained By A Master"
		$$skill	Throwing Art	PH	Cinematic		"Adv:Trained By A Master;Throwing>=16|Adv:Weapon Master;Throwing>=16"
		$$skill	Zen Archery	MVH!	Cinematic		"Adv:Trained By A Master;Bow>=20|Adv:Weapon Master;Bow>=20"
		end
	end


# Martial Arts advantages

cat Advantages
	sublist "Martial Arts" memlist
		$$cadv	Style Familiarity	1
			textline keepcost
		$$ladv	Penalty Reduction	1
		end
	sublist "Cinematic" memlist
		$$cadv	Harmony with the Tao	20		Cinematic
		$$nadv("Iron Hand", "Sk:BreakingBlow+2;Sk:Manual-4*(x>1);b_handsDR+1;handDmg+2", 
			"$One Hand;1;Both Hands;2", x=1?10:15, x=1 or x=2, , Cinematic)
		$$cadv	Sharpshooter	45		Cinematic
		$$cadv	Trained By A Master	40		Cinematic
		$$fladv("Weapon Master", 20, 45, "Weapons", "One Weapon,20;All Archaic Weapons,45", , Cinematic, wpnDmgBonus+c=20?1:2,
			"^n (^x|@c@=20?optValue('Weapon'):'All Archaic Weapons'|)")
			opt	begin text "Weapon" "Choose" keepold noprint selitem "*Skills:Combat/Weapon" end
				end
		end
	sublist "Occult and Paranormal Advantages" memlist
		sublist "Dragon Temple Tattoos" memlist
			$$cadv(Green Dragon Tattoo, 20, , Dragon Temple Tattoo)
			$$cadv(Red Dragon Tattoo, 30, , Dragon Temple Tattoo)
			$$cadv(Golden Dragon Tattoo, 40, , Dragon Temple Tattoo)
			end
		end
	end

# Martial Arts Equipment

cat Equipment
	sublist "Martial Arts Weapons" memlist
		sublist "Chinese Hand Weapons" memlist
			$$sword("Jiann (long sword)", "broadsword,dx-5,~shortsword-2,fencing,fencingrapier)", imp thr+1;cut sw, "1,2;1", 700, 3, 8, "Used primarily for thrusting.","max(fencing,fencingrapier)>broadsword?integer((max(fencing,fencingrapier)+`Accuracy`)*2/3):integer((`Skill`+`Accuracy`)*1/2)")
			$$sword("Dau (scimitar)", "broadsword,dx-5,~shortsword-2", cut sw+2;imp thr, "1;1", 700, 5, 11)
			$$sword("Hook Sword", "broadsword,dx-5,~shortsword-2", cr sw+1;cut thr, "1;1,C", 200, 3, 10, "Can disarm - see p. 117. Lower damage is bladed hand guard.")
			$$handweapon("Three-Part Staff", "flail-1,dx-7", cr sw+4;cr sw+2, "1-3;C,1", 60, 5, 11, "1 turn to re-ready. -2 to block. Lower damage is used as two separate attacks.")
			$$handweapon("Slashing Wheel", "knife,maingauche,dx-4", cut thr+1, C, 60, 1, , "Usually used in pairs. Gives PD 1 for parrying purposes.")
			$$handweapon("Knife-Wheel", "knife,maingauche,dx-4", cut thr+1;imp thr-1, "C;C", 75, 1.5, , "Usually used in pairs. Gives PD 1 for parrying purposes.")
			$$handweapon("Monk's Spade", "polearm,dx-5", cut sw+1;cr sw+1;cut thr+2, "1,2*;1,2*;1,2*", 100, 6, 10, "Blade 1 turn to ready after swing; Shaft 1 turn to ready after swing; Spade 1 turn to ready after swing.")
			$$handweapon("Light Horse-Cutter", "polearm,dx-5", cut sw+4;imp thr+2, "1,2*;1,2*", 120, 8, 12, "2 turns to ready after swing; 1 turn to ready after thrust.")
			$$handweapon("Light Horse-Cutter (staff technique)", "staff,dx-5,~spear-2", cr sw+2;cr thr+2, "1,2;1,2", 120, 8, 12, "Staff technique, with shaft; Staff technique, with blunt end", 2/3)
			$$handweapon("Heavy Horse-Cutter", "polearm,dx-5", cut sw+5;imp thr+3, "2,3*;1-3*", 150, 12, 13, "2 turns to ready after swing; 1 turn to ready after thrust.")
			$$sword("Butterfly Sword", "shortsword,dx-5,~broadsword-2", cut sw+1, 1, 400, 3, 10, "Used in pairs.")
			$$handweapon("Chiang (spear)", "spear,dx-5,~staff-2", imp thr+2;imp thr+3, "1;1, 2*", 40, 4, 9, "Used 1-handed - throwable.; Lower damage is used 2-handed.")
			$$handweapon("Southern-Tiger Fork", "~spear-2,dx-7,~staff-4", imp thr+1;imp thr+2, "1;1,2*", 80, 5, 10, "Used 1-handed (up to 3 attacks).; Used 2-handed (up to 3 attacks).")
			$$handweapon("Staff", "staff,dx-5,~spear-2", cr sw+1;cr thr+2, "1,2;1,2", 10, 4, 6, , 2/3)
			$$handweapon("Chiang (staff technique)", "staff,dx-5,~spear-2", cr sw+2;cr thr+2, "1,2;1,2", 40, 4, 6, "Used as staff, to strike; Used as staff, to jab with blunt end", 2/3)
			$$handweapon("Chain Whip", "whip", cr sw+1, "1-4", 50/yd, 3/yd, 12, "See p. B52. Cannot entangle.")
			end
		sublist "Japanese Hand Weapons" memlist
			$$handweapon("Nata (hatchet)", "axemace,dx-5", cut sw, 1, 40, 2, 7, "1 turn to ready after swing.")
			$$handweapon("Kama (sickle)", "axemace,dx-5", cut sw+2, "1,2", 70, 3, 11, "1 turn to ready after swing.")
			$$handweapon("Masakari (axe)", "axemace,dx-5", cut sw+2, 1, 50, 4, 12, "1 turn to ready after swing.")
			$$handweapon("Nunchaku", "flail,dx-6", cr sw+2, "1,2", 20, 2, 10, "1 turn to re-ready. -2 to block.")
			$$handweapon("Jitte", "jittesai,dx-5,~shortsword-2", cr thr;cr sw, "C,1;C", 20, 1, 7, "Blunt point. Used to disarm.")
			$$handweapon("Sai", "jittesai,dx-5,~shortsword-2", imp thr;cr sw, "C,1;C", 30, 1, 8, "Sharp point, can also disarm.; Swing strike is like jitte.")
			$$sword("Katana", "katana,dx-5,~broadsword-2", cut sw+2;imp thr+1;cr sw+2, "1,2;1;1,2", 650, 5, 11, "Usu. of Fine quality. Quadruple cost at TL6- outside Japan.; Used 2-handed.", 2/3)
			$$sword("Katana (one-handed)", "katana,dx-5,~broadsword-2", cut sw+1;imp thr+1;cr sw+1, "1,2;1;1,2", 650, 5, 11, "Usu. of Fine quality. Quadruple cost at TL6- outside Japan.; Used 1-handed.")
			$$handweapon("Bokken", "katana,dx-5,~broadsword-2", cr sw+2;cr thr+1, "1,2;1", 40, 5, 11, "Wooden training sword.; Used 2-handed", 2/3)
			$$handweapon("Bokken (one-handed)", "katana,dx-5,~broadsword-2", cr sw+1;cr thr+1, "1,2;1", 40, 5, 11, "Wooden training sword.; Used 1-handed")
			$$handweapon("Shinai", "katana,dx-5,~broadsword-2", cr sw;cr thr-1, "1,2;1", 40, 3, 9, "Bamboo training sword.; Used 2-handed", 2/3)
			$$handweapon("Shinai (one-handed)", "katana,dx-5,~broadsword-2", cr sw-1;cr thr-1, "1,2;1", 40, 3, 9, "Bamboo training sword.; Used 2-handed")
			$$handweapon("Hishi", "knife,dx-4", imp thr-1 1d+0, C, 20, .25)
			$$handweapon("Kozuka", "knife,dx-4", cut sw-3 1d+1;imp thr-1 1d+1, "C,1;C", 30, .5)
			$$handweapon("Tanto", "knife,dx-4", cut sw-2 1d+2;imp thr 1d+2, "C,1;C", 40, 1)
			$$handweapon("Kusari", "kusari,dx-5,flail-2", cr sw+2, "1-4", 70, 5, 11, "Can grapple. 1 turn to ready per yard of attack.")
			$$handweapon("Kusari-gama", "kusari,dx-5,~flail-2", cut sw+2, "1,2", 80, 3, 11, "1 turn to ready after swing.")
			$$handweapon("Manriki-gusari", "kusari,dx-5,~flail-2", cr sw+4, "1,2", 60, 3, 11, "Can grapple. 1 turn to ready after each use.")
			$$handweapon("Naginata", "polearm,dx-5", cut sw+3;imp thr+3, "1,2;2", 100, 6, 9, "1 turn to ready after swing.")
			$$handweapon("Jo", "shortstaff,dx-5,~staff-2", cr sw+1;cr thr+1, "1;1", 10, 2)
			$$sword("Wakizashi", "shortsword,dx-5,~broadsword-2", cut sw;imp thr, "1;1", 400, 2, 7, "Samurai's side sword, along with katana.")
			$$handweapon("Rochin (short spear)", "spear,dx-5,~staff-2", imp thr+1, 1, 30, 2, 7, "One-handed stabbing spear.")
			$$handweapon("Yarinage (javelin)", "spear,dx-5,~staff-2", imp thr+1, 1, 30, 2, , "Soldier's throwing weapon.")
			$$handweapon("Yari (spear)", "spear,dx-5,~staff-2", imp thr+2;imp thr+3, "1;1,2*", 40, 4, 9, "Used 1-handed - throwable.; Used 2-handed.")
			$$handweapon("Bo", "staff,dx-5,~spear-2", cr sw+2;cr thr+2, "1,2;1,2", 10, 4, 6, "Requires 2 hands.", 2/3)
			$$handweapon("Naginata (staff technique)", "staff,dx-5,~spear-2", cr sw+2;cr thr+2, "1,2;1,2", 100, 6, 9, "Staff technique, with shaft.; Staff technique, with blunt end.", 2/3)
			$$handweapon("Tetsubo (staff technique)", "staff,dx-5,~spear-2", cr sw+4;cr thr+2, "1,2;1,2", 100, 10, 13, , 2/3)
			$$handweapon("Tonfa", "tonfa,dx-6,~shortsword-3", cr sw+1;cr thr+1, "1;C,1", 40, 2, 7, , 2/3)
			$$sword("Nodachi", "twohandedsword,dx-5", cut sw+4;cr thr+2, "1,2;2", 800, 7, 12, "Worn in a back sheath.; Blunt tip.")
			$$handweapon("Naginata (sword technique)", "twohandedsword,dx-5", cut sw+3;imp thr+3, "1,2;2", 100, 6, 9, "1 turn to ready after swing.; No time to ready after thrust.")
			$$handweapon("Tetsubo (sword technique)", "twohandedsword,dx-5", cr sw+4;cr thr+2, "1,2;2", 100, 10, 13, "1 turn to ready after swing.; No time to ready after thrust.")
			end
		sublist "Japanese Ranged Weapons" memlist
			$$equip("Dai-Kyu (longbow)", 4, 900, "Missile Weapon;Ranged Weapon", "Other stats vary by arrow type")
			$$missile("Armor-piercing arrow", "bow,dx-6", imp thr+1 1d+0, 14, 3, ST*20, ST*25, 2, .125, 10, "-2 to armor DR.")
				opt
					begin mult Quantity "??1;1;x;x>0" noprint end
					end
			$$missile("Bowel-raker arrow", "bow,dx-6", cut thr+3 1d+4, 14, 2, ST*15, ST*20, 2, .125, 10, "1d-3 damage to remove.")
				opt
					begin mult Quantity "??1;1;x;x>0" noprint end
					end
			$$missile("Willow-leaf arrow", "bow,dx-6", cut thr+3 1d+4, 14, 3, ST*20, ST*25, 2, .125, 10)
				opt
					begin mult Quantity "??1;1;x;x>0" noprint end
					end
			end
		sublist "Ninja Weapons" memlist
			$$handweapon("Neko-de (bladed hand)", "dx,brawling,karate", cut sw-2;imp thr, "C;C", 100, 1, , "Receives Brawling or Karate bonuses")
			$$handweapon("Rope Garrote", "garrote,dx-5", cr thr, "C*", 1, .625, , "Damage only if wrapped around neck.")
			$$handweapon("Wire Garrote", "garrote,dx-5", cut thr, "C*", 5, .3125, , "See pp. MA33, 119")
			$$handweapon("Oh-gama", "kusari,dx-5,~flail-2", cut sw+4, "1-4", 130, 8, 12, "1 turn to ready after swing")
			$$sword("Ninja-to", "shortsword,dx-5,~broadsword-2", cut sw;imp thr, "1;1", 400, 2, 7)
			end
		sublist "Ninja Ranged Weapons" memlist
			$$missile("Blowpipe", "blowpipe,dx-6", , 10, 1, , ST*4, 30, 1, , "See p. MA119")
			$$equip("Han-kyu (shortbow)", 2.5, 600, "Missile Weapon;Ranged Weapon", "Other stats vary by arrow type")
			$$missile("Armor-piercing arrow (shortbow)", "bow,dx-6", imp thr-2 1d-1, 12, 1, ST*10, ST*15, 2, .125, 7, "-2 to armor DR")
				opt
					begin mult Quantity "??1;1;x;x>0" noprint end
					end
			$$missile("Bowel-raker arrow (shortbow)", "bow,dx-6", cut thr 1d+3, 12, 0, ST*5, ST*10, 2, .125, 7, "1d-3 to remove")
				opt
					begin mult Quantity "??1;1;x;x>0" noprint end
					end
			$$missile("Willow-leaf arrow (shortbow)", "bow,dx-6", cut thr 1d+3, 12, 1, ST*10, ST*15, 2, .125, 7)
				opt
					begin mult Quantity "??1;1;x;x>0" noprint end
					end
			$$missile("Nageteppo (grenade)", "dx-3,throwing", , 12, 0, , ST*3.5, 50, 1)
			$$missile("Stun Munition (grenade)", "dx-3,throwing", , 12, 0, , ST*3.5, 40, 1)
			$$missile("Hishi (dagger)", "knifethrowing,throwing,dx-4", imp thr-1 1d+0, 12, 0, ST-5, ST, 20, .25)
			$$missile("Kozuka (small knife)", "knifethrowing,throwing,dx-4", imp thr-1 1d+1, 11, 0, ST-5, ST, 30, .5)
			$$missile("Shuriken (starblade)", "shuriken,dx-6,throwing-2", cut thr-1 1d+2, 8, 1, ST-5, ST, 3, .1, , "Usu. in set of 9")
				opt
					begin mult Quantity "??1;1;x;x>0" noprint end
					end
			end
		sublist "Indian Weapons" memlist
			$$handweapon("Otta", "broadsword,dx-5", cr sw+1;cr thr+1, "1;1", 60, 3, 10, "S-shaped club")
			$$handweapon("Katar (small)", "knife,dx-4", imp thr+1;cut sw-3, "C;C,1", 40, 1, , "Perpendicular grip.; A knife-sized katar.")
			$$sword("Katar (large)", "shortsword,dx-5,broadsword-2", imp thr+1;cut sw-1, "1;1", 400, 2, 7, "Perpendicular grip.; A sword-sized katar")
			$$handweapon("Muchan", "staff,dx-5,spear-2", cr sw;cr thr, "1;1", 10, 1, 7, "Baton-sized, but used two-handed", 2/3)
			$$handweapon("Gada", "twohandedaxemace,dx-5", cr sw+3;cr thr+2, "1,2;1", 60, 9, 13, "1 turn to ready after swing/thrust")
			$$handweapon("Urumi", "whip", cr sw-1 1d+2, "1-3", 400, 4, 8, "See p. B52")
			end
		sublist "Indonesian Weapons" memlist
			$$handweapon("Kris", "knife,maingauche,dx-4", cut sw-2 1d+2;imp thr 1d+2, "C,1;C", 40, 1, , "This is a large kris.")
			$$handweapon("Pisau", "knife,maingauche,dx-4", cut sw-3 1d+1;imp thr-1 1d+1, "C,1;C", 30, .5)
			$$handweapon("Latajang", "polearm,dx-5", cut sw+2;cut thr+1, "1,2*;1,2*", 100, 7, 10, "1 turn to ready after swing/thrust")
			$$sword("Parang", "shortsword,dx-5,~broadsword-2", cut sw+1, 1, 400, 3, 10)
			$$sword("Pedang", "shortsword,dx-5,~broadsword-2", cut sw;imp thr, "1;1", 400, 2, 7)
			end
		sublist "Korean Weapons" memlist
			$$handweapon("Combat Fan", "karate,dx-2", cut thr-2 1d-1;cr thr, "C;C,1", 40, 1, , "Cut uses DX-2;Crushing uses Karate and receives Karate bonuses")
			$$sword("Gum", "katana,dx-5,~broadsword-2", cut sw+1;imp thr+1;cut sw+2, "1,2;1;1,2", 162.5, 5, 11, "Usually of Fine quality. Used 1-handed.; ; Used 2-handed", 2/3)
			$$handweapon("Dan Bong", "shortstaff,dx-5,staff-2", cr sw;cr thr, "1;1", 10, 1, 7)
			$$sword("Dan Sang Gum", "shortsword,dx-5,~broadsword-2", cut sw+1, 1, 400, 3, 10, "Often used in pairs")
			end
		sublist "Philippine Weapons" memlist
			$$handweapon("Punal", "knife,dx-4,maingauche", cut sw-2 1d+2;imp thr 1d+2, "C,1;C", 40, 1)
			$$handweapon("Balisong Knife", "knife,dx-4,maingauche", cut sw-3 1d+1;imp thr-1 1d+1, "C,1;1", 30, .5, , "+1 to Holdout skill")
			$$handweapon("Escrima Stick", "shortsword,dx-5,~broadsword-2,shortstaff,~staff-2", cr sw;cr thr, "1;1", 20, 1)
			$$handweapon("Bullwhip", "whip", cr sw-2 1d-1, "1-7", 20/yd, 2/yd, 10, "See p. B52")
			end
		sublist "European Fencing Weapons" memlist
			$$shield("Heavy Cloak", "cloak,dx-5,~buckler-4,~shield-4", 2, 50, 5, 5)
			$$shield("Light Cloak", "cloak,dx-5,~buckler-4,~shield-4", 1, 20, 2, 3)
			$$sword("Fencing Saber", "fencing,fencingsaber,dx-5", imp thr+1 1d+2;cut sw-1 1d+0, "1;1", 400, 2, , "May Break.")
			$$sword("Smallsword", "fencing,fencingsmallsword,dx-5", imp thr+1 1d+1, 1, 400, 1.5)
			$$sword("Dress Smallsword", "fencing,fencingsmallsword,dx-5", imp thr 1d+0, 1, 300, 1)
			$$sword("Swordcane", "fencing,fencingsmallsword,dx-5", imp thr+1 1d+1, 1, 450, 4)
			$$sword("Dress Swordcane", "fencing,fencingsmallsword,dx-5", imp thr 1d+0, 1, 350, 2.5)
			$$sword("Rapier", "fencing,fencingrapier,dx-5", imp thr+1 1d+1, "1,2", 500, 2, 7, , "(fencing+fencingrapier?2/3:.5)")
			$$sword("Slashing Rapier", "fencing,fencingrapier,dx-5", imp thr+1 1d+1;cut sw, "1,2;1,2", 1000, 2, 7, "1 turn to ready after a swing.", "(fencing+fencingrapier?2/3:.5)")
			$$handweapon("Main-Gauche", "maingauche,dx-5", imp thr 1d+2;cut sw-3 1d+1, "C;C,1", 50, 1.25, , , 2/3)
			end
		sublist "Ultra-Tech Weapons" memlist
			$$fsword	Force Sword	forcesword,katana,dx-5	imp 4d(5);cut 8d(5)	1;1	3000	2
			$$fsword	Sonic Blade	forcesword,katana,dx-5	cr 5d(5)	C,1	2500	2.5
			$$handweapon	Monowire Whip	monomolecularwhip,~whip-2	cut sw-2	1-7	900	0.5		+1d(10) damage
			end
		sublist "Training Equipment" memlist
			$$handweapon("Electronic Foil", "fencing,fencingsmallsword,dx-5", , "1,2", 2000, 70)
			$$equip("Rubber Weapon", 0, 5)
			$$equip("Digital Weapon", 0, 500)
			$$equip("Digital Judging Computer", 0, 1000)
			$$armor("Digital Sparring Armor", 8, 0, 2, 3000, 18, "Body,Arms,Legs,Whole", "DR 16 vs. crushing attacks.")
			$$armor("Advanced Digital Sparring Armor", 8, 0, 2, 8000, 25, "Body,Arms,Legs,Whole", "DR 16 vs. crushing attacks.")
			$$armor("Virtual Reality Sparring Helmet", 8, 0, 10, 4000, 5, "Head", "7 hits will disable; 15 hits will destroy")
			end
		sublist "Armor" memlist
			$$armor("Leather Do", 3, 2, 2, 60, 9, "Body")
			$$armor("Full Leather Samurai Armor", 3, 2, 2, 140, 20, "Body,Arms,Legs,Whole")
			$$armor("Bamboo-reinforced Leather Do", 3, 2, 3, 100, 11, "Body")
			$$armor("Full Bamboo-reinforced Samurai Armor", 3, 2, 3, 220, 25, "Body,Arms,Legs,Whole")
			$$armor("Steel Do", 4, 3, 4, 100, 15, "Body")
			$$armor("Full Steel Samurai Armor", 4, 3, 4, 375, 35, "Body,Arms,Legs,Whole")
			$$armor("Kendo Armor", 5, 2, 3, 700, 10, "Body,Arms,Legs,Whole", "PD 1, DR 2 vs. cut/imp attacks.")
			$$armor("Ninja Armor", 3, 1, 3, 100, 20, "Body,Arms,Legs,Whole")
			$$armor("Boxing Gloves", 5, 1, 2, 60, 1, "Hands", "1/2 Punch damage;PD adds to parry")
			$$armor("Modern Body Armor", 7, 1, 3, 100, 10, "Body,Arms,Legs,Whole", "PD 1, DR 2 vs. cut/imp attacks")
			end
		end
	end



options
	list "Martial Arts"
		begin percent "Only When Flying" -30%
			end
		begin text "Skill Reference" "?!@v@" noprint
			end
		begin text "Parry Reference" "?!@Parry@" noprint itemrefcat "Melee"
			end
		begin text "Primary Skill" "" cat "Primary Skill" usemsg noprint
			checkexp "machk(x,c);$mamsg(x,c)" end
		begin text "Secondary Skill" "" cat "Secondary Skill" usemsg noprint
			checkexp "machk(x,c);$mamsg(x,c)" end
		begin text "Optional Skill" "" cat "Optional Skill" usemsg noprint
			checkexp "machk(x,c);$mamsg(x,c)" end
		begin text "Cinematic Skill" "" cat "Cinematic Skill" usemsg noprint 
			checkexp "machk(x,c);$mamsg(x,c)" end
		begin text "Style" "" noprint keepold end
		end
	end

end
